 ; Ŀ
 ;   Glk - Grdraw Clock Display                                            
 ;   Copyright 1991, 2001, 2007 by Rocket Software                         
 ;   Analog displays are infinitely preferable to digital.                 
 ; 

 ; Ŀ
 ;   Ccrl - grdraw a set of radial lines.                                  
 ;   Arguments: Pa, the proposed centre point.                             
 ;              Reps, the number of lines to draw.                         
 ;              Rad, the circle radius.                                    
 ;              Frac, the radial line length as a fraction of the circle   
 ;                    radius.  Lines are drawn so that they touch the      
 ;                    outer edge of the circle.                            
 ;              Colo, the line colour.                                     
 ;   Calls nothing, returns nothing, but has a good attitude.              
 ; 
 (DEFUN CCRL (pa reps rad frac colo / rad rad2 angg incr)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (repeat reps
          (grdraw (polar pa angg (- rad (* rad frac)))
                  (polar pa angg rad) colo)
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Ccrl end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ;   Arguments: Pa, the centre point.                                      
 ;              Radd, the circle radius.                                   
 ;              Reps, the number of lines with which to approximate        
 ;                    the circle.                                          
 ;              Colo, the line colour.                                     
 ; 
 (DEFUN CI (pa radd reps colo / reps pa pa1 pa2 angg)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Glk.                                                       
 ; 
 (DEFUN GLK (pa rad / ang pa cd thr tmn hrang minang)
  (setq ang (getvar "angbase"))
  (setvar "angbase" 0)
  (ci pa rad 32 1)
  (ci pa (* rad 0.1) 16 8)
  (ccrl pa 12 rad 0.2 8)
  (ccrl pa 60 rad 0.08 8)
  (setq cd (getvar "cdate"))
  (setq thr (fix (* 100 (- cd (fix cd)))))
  (setq tmn (fix (* 100 (- (* 100 cd) (fix (* 100 cd))))))
  (setq hrang (+ (/ pi 2)(* -1 (+ (/ (* thr pi) 6) (/ (* tmn pi) 360)))))
  (setq minang (+ (/ pi 2)(* -1 (/ (* pi tmn) 30))))
  (grdraw (polar pa hrang (* rad 0.1)) (polar pa hrang (* rad 0.5)) 8)
  (grdraw (polar pa minang (* rad 0.1)) (polar pa minang (* rad 0.8)) 8)
  (setvar "angbase" ang)
 (princ))
 ; Ŀ
 ;   Glk.                                                                  
 ; 

 ; Ŀ
 ;   Glk.                                                                  
 ; 
 (DEFUN C:GLK (/ rad pa)
  (setq rad (/ (getvar "viewsize") 24))
  (setq pa (getpoint "Pick centre point:"))
  (glk pa rad)
 (princ))